---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-RDD（Resilient Distributed Dataset）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **推奨パーティションサイズ128MB**：公式ドキュメントからの要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 56-83行目 - RDDのScaladoc（5プロパティ説明）
- E-02: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 84-87行目 - RDD抽象クラス定義
- E-03: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 89-93行目 - ネストRDD警告
- E-04: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 116行目 - compute抽象メソッド
- E-05: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 125行目 - getPartitions抽象メソッド
- E-06: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 131行目 - getDependencies
- E-07: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 136行目 - getPreferredLocations
- E-08: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 139行目 - partitioner
- E-09: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 119-124行目 - パーティションインデックス制約
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 3行目 - 機能定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - Storage/RDD Detail画面との関連
- E-12: rddディレクトリ内の各RDD実装ファイル一覧
- E-13: `core/src/main/scala/org/apache/spark/rdd/RDD.scala` 95-100行目 - SparkContext null チェック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RDDは耐障害性を持つ不変な分散コレクション | E-01 | ○ |
| C-02 | RDDは5つの主要プロパティで特徴付けられる | E-01, E-04, E-05, E-06, E-07, E-08 | ○ |
| C-03 | 変換操作は遅延評価される | E-01 | ○ |
| C-04 | リネージベースの再計算で耐障害性を実現 | E-01, E-06 | ○ |
| C-05 | ネストRDDは非サポート（SPARK-5063） | E-03 | ○ |
| C-06 | パーティションインデックスが配列インデックスと一致する必要あり | E-09 | ○ |
| C-07 | SparkContextがnullの場合にエラー | E-13 | ○ |
| C-08 | compute()は各パーティションの計算を実行 | E-04 | ○ |
| C-09 | Storage画面でRDD一覧が表示される | E-11 | ○ |
| C-10 | RDD Detail画面でRDD詳細が表示される | E-11 | ○ |
| C-11 | MapPartitionsRDD等の実装がrddディレクトリに存在 | E-12 | ○ |
| C-12 | NarrowDependencyとShuffleDependencyの2種類の依存関係 | E-01 | ○ |
| C-13 | checkpointによるリネージ切断が可能 | E-01 | ○ |
| C-14 | DataFrame/DatasetもRDDを基盤としている | E-10 | ○ |
| C-15 | @transientフィールドはシリアライズ時にnullとなる | E-02 | ○ |
| C-16 | タスク失敗はspark.task.maxFailures回までリトライ | E-01 | ○ |
| C-17 | OutputCommitCoordinatorが重複書き込みを防止 | E-01 | ○ |
| C-18 | 推奨パーティションサイズはタスクあたり128MB | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: 推奨パーティションサイズ128MBはApache Spark公式ドキュメントのチューニングガイドに記載があるとされるが、ソースコード内には明示的な記載がない
  - 候補：公式ドキュメント / Sparkチューニングガイド / HDFS デフォルトブロックサイズとの関連

## 5) リスクフラグ（レビュー観点）
- 0: RDDの5プロパティ定義 - ソースコードのScaladocから直接確認済み
- 0: 不変性と遅延評価の特性 - ソースコードの設計から確認済み
- 1: パフォーマンス推奨値 - ソースコード外の知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] RDDの5つの主要プロパティの説明が正確か
- [ ] 依存関係（Narrow/Wide）の分類が正確か
- [ ] キャッシュ/チェックポイントの動作説明が正確か
- [ ] 関連画面マッピングが画面機能マッピング.csvと一致しているか
